*****************************************************************************
* Figure 1. Average test by group and treatment: U.S. vs. Shanghai
*****************************************************************************

********************
* Panel A. Full test
********************
use MSIE_AERI.dta, clear

collapse (mean) meanscore=score (sd) sdscore=score (count) n=score, by(levelgrp t2)

gen shanghai_t=2 if levelgrp=="low s1" & t2=="baseline"
replace shanghai_t=4 if levelgrp=="low s1" & t2=="treatment"
replace shanghai_t=7 if levelgrp=="regular s1" & t2=="baseline"
replace shanghai_t=9 if levelgrp=="regular s1" & t2=="treatment"
replace shanghai_t=12 if levelgrp=="honors s1" & t2=="baseline"
replace shanghai_t=14 if levelgrp=="honors s1" & t2=="treatment"
replace shanghai_t=17 if levelgrp=="regular s2" & t2=="baseline"
replace shanghai_t=19 if levelgrp=="regular s2" & t2=="treatment"
replace shanghai_t=22 if levelgrp=="honors s2" & t2=="baseline"
replace shanghai_t=24 if levelgrp=="honors s2" & t2=="treatment"
replace shanghai_t=30 if levelgrp=="shanghai low" & t2=="baseline"
replace shanghai_t=32 if levelgrp=="shanghai low" & t2=="treatment"
replace shanghai_t=35 if levelgrp=="shanghai med 1" & t2=="baseline"
replace shanghai_t=37 if levelgrp=="shanghai med 1" & t2=="treatment"
replace shanghai_t=40 if levelgrp=="shanghai med 2" & t2=="baseline"
replace shanghai_t=42 if levelgrp=="shanghai med 2" & t2=="treatment"
replace shanghai_t=45 if levelgrp=="shanghai high" & t2=="baseline"
replace shanghai_t=47 if levelgrp=="shanghai high" & t2=="treatment"

gen ylabpos=-3 if _n==1  | _n==2
gen xlabpos=8 if _n==1 	
replace xlabpos=20.5 if _n==2
gen xlab="School 1" if _n==1
replace xlab="School 2" if _n==2

gen ylabpos2=-1 
gen xlabpos2=3 if _n==1 	
replace xlabpos2=8 if _n==2
replace xlabpos2=13 if _n==3
replace xlabpos2=18 if _n==4
replace xlabpos2=23 if _n==5
replace xlabpos2=31 if _n==6
replace xlabpos2=36 if _n==7
replace xlabpos2=41 if _n==8
replace xlabpos2=46 if _n==9
gen xlab2="School 1" if _n==1
replace xlab2="School 1" if _n==2
replace xlab2="School 1" if _n==3
replace xlab2="School 2" if _n==4
replace xlab2="School 2" if _n==5
replace xlab2="School 1" if _n==6
replace xlab2="School 2" if _n==7
replace xlab2="School 3" if _n==8
replace xlab2="School 4" if _n==9

gen ylabpos3=-2
gen xlabpos3=3 if _n==1 	
replace xlabpos3=8 if _n==2
replace xlabpos3=13 if _n==3
replace xlabpos3=18 if _n==4
replace xlabpos3=23 if _n==5

gen xlab3="Low" if _n==1
replace xlab3="Regular" if _n==2
replace xlab3="Honors" if _n==3
replace xlab3="Regular" if _n==4
replace xlab3="Honors" if _n==5


gen ycolabpos=24
gen xcolabpos=13 if _n==1
replace xcolabpos=38.5 if _n==2
gen colab="U.S" if _n==1
replace colab="Shanghai" if _n==2

format meanscore %9.1f
gen xplot=shanghai_t
gen yplot=meanscore*0.5

gen redlinex=27
gen redliney=0 if n<50
replace redliney=25 if n>50
gen c=shanghai_t==2 | shanghai_t==7 | shanghai_t==12 | shanghai_t==17 | shanghai_t==22 | shanghai_t==27 | shanghai_t==32 | shanghai_t==37 

twoway  (bar meanscore shanghai_t if shanghai_t==2, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==4, color(orange)  barw(2))  ///
		(bar meanscore shanghai_t if shanghai_t==7, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==9, color(orange)  barw(2))  ///
		(bar meanscore shanghai_t if shanghai_t==12, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==14, color(orange)  barw(2))  ///
		(bar meanscore shanghai_t if shanghai_t==17, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==19, color(orange)  barw(2))  ///	
		(bar meanscore shanghai_t if shanghai_t==22, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==24, color(orange)  barw(2))  ///	
		(bar meanscore shanghai_t if shanghai_t==30, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==32, color(orange)  barw(2))  ///
		(bar meanscore shanghai_t if shanghai_t==35, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==37, color(orange)  barw(2))  ///
		(bar meanscore shanghai_t if shanghai_t==40, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==42, color(orange)  barw(2))  ///
		(bar meanscore shanghai_t if shanghai_t==45, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==47, color(orange)  barw(2))  ///
		(scatter yplot xplot, msymbol(i) mlab(meanscore) mlabposition(0) mlabsize(vsmall) mlabcolor(gs5)) ///
		(scatter ylabpos2 xlabpos2, msymbol(i) mlab(xlab2) mlabposition(0) mlabsize(vsmall) mlabcolor(gs5)) ///
		(scatter ylabpos3 xlabpos3, msymbol(i) mlab(xlab3) mlabposition(0) mlabsize(vsmall) mlabcolor(gs5)) ///
		(scatter ycolabpos xcolabpos, msymbol(i) mlab(colab) mlabposition(0) mlabsize(medium) mlabcolor(gs5)) ///
		(line redliney redlinex, color(red)), ///
		xlabel("")  ///
		xtick(0(1)48, noticks) ///
		plotregion(style(none)) ///
		ysca(noline) ///
		xsca(noline) ///
		ylabel( 0 "0" 5 "5" 10 "10" 15 "15" 20 "20" 25 "25", labcolor(gs5))  ///
		legend(row(1) order(1 "Control" 2 "Treatment") region(lwidth(none))) ///
		ytitle("Score" "(out of 25)", orientation(horizontal) color(gs5))  ///
		xtitle("") ///
		yline(0 5 10 15 20 25, lcolor(gs14)) ///
		scheme(s1color)


****************************************
* Panel B. Nine questions from 2012 PISA
****************************************
use MSIE_AERI.dta, clear

collapse (mean) meanscore=score9q (sd) sdscore=score9q (count) n=score9q, by(levelgrp t2)

gen shanghai_t=2 if levelgrp=="low s1" & t2=="baseline"
replace shanghai_t=4 if levelgrp=="low s1" & t2=="treatment"
replace shanghai_t=7 if levelgrp=="regular s1" & t2=="baseline"
replace shanghai_t=9 if levelgrp=="regular s1" & t2=="treatment"
replace shanghai_t=12 if levelgrp=="honors s1" & t2=="baseline"
replace shanghai_t=14 if levelgrp=="honors s1" & t2=="treatment"
replace shanghai_t=17 if levelgrp=="regular s2" & t2=="baseline"
replace shanghai_t=19 if levelgrp=="regular s2" & t2=="treatment"
replace shanghai_t=22 if levelgrp=="honors s2" & t2=="baseline"
replace shanghai_t=24 if levelgrp=="honors s2" & t2=="treatment"
replace shanghai_t=30 if levelgrp=="shanghai low" & t2=="baseline"
replace shanghai_t=32 if levelgrp=="shanghai low" & t2=="treatment"
replace shanghai_t=35 if levelgrp=="shanghai med 1" & t2=="baseline"
replace shanghai_t=37 if levelgrp=="shanghai med 1" & t2=="treatment"
replace shanghai_t=40 if levelgrp=="shanghai med 2" & t2=="baseline"
replace shanghai_t=42 if levelgrp=="shanghai med 2" & t2=="treatment"
replace shanghai_t=45 if levelgrp=="shanghai high" & t2=="baseline"
replace shanghai_t=47 if levelgrp=="shanghai high" & t2=="treatment"

gen ylabpos=-3 if _n==1  | _n==2
gen xlabpos=8 if _n==1 	
replace xlabpos=20.5 if _n==2
gen xlab="School 1" if _n==1
replace xlab="School 2" if _n==2

gen ylabpos2=-1 
gen xlabpos2=3 if _n==1 	
replace xlabpos2=8 if _n==2
replace xlabpos2=13 if _n==3
replace xlabpos2=18 if _n==4
replace xlabpos2=23 if _n==5
replace xlabpos2=31 if _n==6
replace xlabpos2=36 if _n==7
replace xlabpos2=41 if _n==8
replace xlabpos2=46 if _n==9
gen xlab2="School 1" if _n==1
replace xlab2="School 1" if _n==2
replace xlab2="School 1" if _n==3
replace xlab2="School 2" if _n==4
replace xlab2="School 2" if _n==5
replace xlab2="School 1" if _n==6
replace xlab2="School 2" if _n==7
replace xlab2="School 3" if _n==8
replace xlab2="School 4" if _n==9

gen ylabpos3=-1.4
gen xlabpos3=3 if _n==1 	
replace xlabpos3=8 if _n==2
replace xlabpos3=13 if _n==3
replace xlabpos3=18 if _n==4
replace xlabpos3=23 if _n==5

gen xlab3="Low" if _n==1
replace xlab3="Regular" if _n==2
replace xlab3="Honors" if _n==3
replace xlab3="Regular" if _n==4
replace xlab3="Honors" if _n==5


gen ycolabpos=9.5
gen xcolabpos=13 if _n==1
replace xcolabpos=38.5 if _n==2
gen colab="U.S" if _n==1
replace colab="Shanghai" if _n==2

format meanscore %9.1f
gen xplot=shanghai_t
gen yplot=meanscore*0.5

gen redlinex=27
gen redliney=0 if n<50
replace redliney=10 if n>50
gen c=shanghai_t==2 | shanghai_t==7 | shanghai_t==12 | shanghai_t==17 | shanghai_t==22 | shanghai_t==27 | shanghai_t==32 | shanghai_t==37 

twoway  (bar meanscore shanghai_t if shanghai_t==2, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==4, color(orange)  barw(2))  ///
		(bar meanscore shanghai_t if shanghai_t==7, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==9, color(orange)  barw(2))  ///
		(bar meanscore shanghai_t if shanghai_t==12, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==14, color(orange)  barw(2))  ///
		(bar meanscore shanghai_t if shanghai_t==17, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==19, color(orange)  barw(2))  ///	
		(bar meanscore shanghai_t if shanghai_t==22, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==24, color(orange)  barw(2))  ///	
		(bar meanscore shanghai_t if shanghai_t==30, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==32, color(orange)  barw(2))  ///
		(bar meanscore shanghai_t if shanghai_t==35, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==37, color(orange)  barw(2))  ///
		(bar meanscore shanghai_t if shanghai_t==40, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==42, color(orange)  barw(2))  ///
		(bar meanscore shanghai_t if shanghai_t==45, color(ebblue) barw(2)) ///
		(bar meanscore shanghai_t if shanghai_t==47, color(orange)  barw(2))  ///
		(scatter yplot xplot, msymbol(i) mlab(meanscore) mlabposition(0) mlabsize(vsmall) mlabcolor(gs5)) ///
		(scatter ylabpos2 xlabpos2, msymbol(i) mlab(xlab2) mlabposition(0) mlabsize(vsmall) mlabcolor(gs5)) ///
		(scatter ylabpos3 xlabpos3, msymbol(i) mlab(xlab3) mlabposition(0) mlabsize(vsmall) mlabcolor(gs5)) ///
		(scatter ycolabpos xcolabpos, msymbol(i) mlab(colab) mlabposition(0) mlabsize(medium) mlabcolor(gs5)) ///
		(line redliney redlinex, color(red)), ///
		xlabel("")  ///
		xtick(0(1)48, noticks) ///
		plotregion(style(none)) ///
		ysca(noline) ///
		xsca(noline) ///
		ylabel( 0 "0" 2 "2" 4 "4" 6 "6" 8 "8" 10 "10", labcolor(gs5))  ///
		legend(row(1) order(1 "Control" 2 "Treatment") region(lwidth(none))) ///
		ytitle("Score" "(out of 9)", orientation(horizontal) color(gs5))  ///
		xtitle("") ///
		yline(0 2 4 6 8 10, lcolor(gs14)) ///
		scheme(s1color)

		
*****************************************************************************
* Figure 2. Treatment Effects on Test Scores by Predicted Score, U.S.
*****************************************************************************

*************
* U.S. panels
*************
use MSIE_AERI.dta, clear
keep if us==1

*** generate predicted scores
* School 1 predicted scores

gen mcas7_ms = missing(mcas7) & school=="us school 1"
 qui su mcas7
 replace mcas7 = r(mean) if mcas7_ms==1
reg score mcas7 mcas7_ms female age agemissing white black hisp_w hisp_nw other asian if t==0 & school=="us school 1"
predict scorehat_s1, xb


* School 2 predicted score
gen ssat_ms = missing(ssat_quant) & school=="tga"
foreach var of varlist ssat* {
 qui su `var'
 replace `var' = r(mean) if ssat_ms ==1 
}
reg score ssat_quant ssat_ms female age agemissing white black hisp_w hisp_nw other asian if t==0 & school=="us school 2"
predict scorehat_s2, xb

drop scorehat

gen scorehat = scorehat_s1 if school=="us school 1"
replace scorehat = scorehat_s2 if school=="us school 2"

* Questions Attempted and Share Attempted Correct
forv i=1/25 {
  gen blank_q`i' = missing(q`i')
  gen attempt_q`i' = 1-blank_q`i'
}
egen attempt_score = rowtotal(attempt_q*)
gen correct_attempt = score/attempt_score

***************************
* Panel A. Test Score, U.S.
***************************
local mean=14.14688
graph twoway (scatter score scorehat if t==1, msize(tiny) color(navy)) (lpoly score scorehat if t==1, lcolor(navy)) ///
	(scatter score scorehat if t==0, msize(tiny) mcolor(maroon)) (lpoly score scorehat if t==0, lcolor(maroon)) , ///
	legend(order(1 "Treatment" 3 "Control")) xtitle("Predicted Test Score") ytitle("Test Score") ///
	graphregion(fcolor(white)) ylabel(,nogrid) xline(`mean', lcolor(black) lpattern(dash)) scheme(s1color) plotregion(style(none)) xlabel(0(5)25)
 
 
************************************
* Panel C. Questions Attempted, U.S.
************************************
local mean=14.14688
graph twoway (scatter attempt_score scorehat if t==1, msize(tiny) color(navy)) (lpoly attempt_score scorehat if t==1, lcolor(navy)) ///
	(scatter attempt_score scorehat if t==0, msize(tiny) mcolor(maroon)) (lpoly attempt_score scorehat if t==0, lcolor(maroon)) , ///
	legend(order(1 "Treatment" 3 "Control")) xtitle("Predicted Test Score") ytitle("# of Questions Attempted") ///
	graphregion(fcolor(white)) ylabel(,nogrid) xline(`mean', lcolor(black) lpattern(dash)) scheme(s1color) plotregion(style(none)) xlabel(0(5)25)

	
******************************************
* Panel E. Share of Correct Attempts, U.S.
******************************************
local mean=14.14688
graph twoway (scatter correct_attempt scorehat if t==1, msize(tiny) color(navy)) (lpoly correct_attempt scorehat if t==1, lcolor(navy)) ///
	(scatter correct_attempt scorehat if t==0, msize(tiny) mcolor(maroon)) (lpoly correct_attempt scorehat if t==0, lcolor(maroon)) , ///
	legend(order(1 "Treatment" 3 "Control")) xtitle("Predicted Test Score") ytitle("Share of Correct Attempts") ///
	graphregion(fcolor(white)) ylabel(,nogrid) xline(`mean', lcolor(black) lpattern(dash)) scheme(s1color) plotregion(style(none) m(zero)) xlabel(0(5)25)

	
******************
* Shanghai panels
******************
use "MSIE_AERI.dta", clear
keep if us==0

drop scorehat

* generate predicted scores
reg score entrance female age t2018 if t==0 & sh_school1==1
predict scorehat_s1, xb

reg score entrance female age t2018 if t==0 & sh_school2==1
predict scorehat_s2, xb

reg score entrance female age t2018 if t==0 & sh_school3==1
predict scorehat_s3, xb

reg score entrance female age t2018 if t==0 & sh_school4==1
predict scorehat_s5, xb

gen scorehat=scorehat_s1 if sh_school1==1
replace scorehat=scorehat_s2 if sh_school2==1
replace scorehat=scorehat_s3 if sh_school3==1
replace scorehat=scorehat_s5 if sh_school4==1



* Questions Attempted and Share Attempted Correct
forv i=1/25 {
  gen blank_q`i' = missing(q`i')
  gen attempt_q`i' = 1-blank_q`i'
}
egen attempt_score = rowtotal(attempt_q*)
gen correct_attempt = score/attempt_score

keep if scorehat<24 & scorehat >17



*******************************
* Panel B. Test Score, Shanghai
*******************************
graph twoway (scatter score scorehat if t==1, msize(tiny) color(navy)) (lpoly score scorehat if t==1, lcolor(navy)) ///
	(scatter score scorehat if t==0, msize(tiny) mcolor(maroon)) (lpoly score scorehat if t==0, lcolor(maroon)) , ///
	legend(order(1 "Treatment" 3 "Control")) xtitle("Predicted Test Score") ytitle("Test Score") ///
	graphregion(fcolor(white)) ylabel(0(5)25,nogrid) scheme(s1color) xlabel(15(5)25) plotregion(style(none)) 


****************************************
* Panel D. Questions Attempted, Shanghai
****************************************
graph twoway (scatter attempt_score scorehat if t==1, msize(tiny) color(navy)) (lpoly attempt_score scorehat if t==1, lcolor(navy)) ///
	(scatter attempt_score scorehat if t==0, msize(tiny) mcolor(maroon)) (lpoly attempt_score scorehat if t==0, lcolor(maroon)) , ///
	legend(order(1 "Treatment" 3 "Control")) xtitle("Predicted Test Score") ytitle("No. of Questions Attempted") ///
	graphregion(fcolor(white)) ylabel(,nogrid) scheme(s1color) xlabel(15(5)25) ylabel(0(5)25) plotregion(style(none)) 


**********************************************
* Panel F. Share of Correct Attempts, Shanghai
**********************************************
graph twoway (scatter correct_attempt scorehat if t==1, msize(tiny) color(navy)) (lpoly correct_attempt scorehat if t==1, lcolor(navy)) ///
	(scatter correct_attempt scorehat if t==0, msize(tiny) mcolor(maroon)) (lpoly correct_attempt scorehat if t==0, lcolor(maroon)) , ///
	legend(order(1 "Treatment" 3 "Control")) xtitle("Predicted Test Score") ytitle("Share of Correct Attempts") ///
	graphregion(fcolor(white)) ylabel(,nogrid) scheme(s1color) xlabel(15(5)25) ylabel(0(.2)1) plotregion(style(none)) 

	
*****************************************************************************
* Figure A.1 Marginal benefits and cost curves
*****************************************************************************

* Produced in latex



*****************************************************************************
* Figure A.2. PISA worldwide percentage correct
*****************************************************************************
use correct_byQ.dta, clear

graph twoway (scatter tot question if mc==1, mcolor(blue)) ///
(scatter tot question if open==1, mcolor(red) ytitle("Percent Correct", orientation(vertical)) xtitle("Question Number") text(58 23 "{&rho} = 0.14", place(ne))) ///
(lfit tot question, lcolor(black)), legend(row(1) order(1 "Multiple Choice" 2 "Free Answer")) plotregion(style(none)) ytick(0(20)100, noticks) scheme(s1color) ///
ylabel(0(20)100) xlabel(0(5)25)


*****************************************************************************
* Figure A.3. Distribution of test scores by treatment group
*****************************************************************************
use MSIE_AERI.dta, clear

drop us_t
rename score Score

cumul Score if us==1 & t==0, gen(us_b) equal
cumul Score if us==1 & t==1, gen(us_t) equal
cumul Score if us==0 & t==0, gen(shang_b) equal
cumul Score if us==0 & t==1, gen(shang_t) equal

twoway (line us_b Score, sort lcolor(navy) lpattern(dash)) (line shang_b Score, sort lcolor(maroon) lpattern(dash)) (line us_t Score, sort lcolor(navy)) (line shang_t Score, sort lcolor(maroon)) , ///
legend(row(2) order(1 "U.S. Control" 2 "Shanghai Control" 3 "U.S. Treatment" 4 "Shanghai Treatment") region(lwidth(none))) ///
ytitle (Empirical CDF) ///
scheme(s1color) plotregion(style(none))


*****************************************************************************
* Figure A.4. Proportion of questions answered by question and treatment group
*****************************************************************************
use MSIE_AERI.dta, clear

forval i=1/25 {
gen q`i'a=q`i'm==0
}
collapse (mean) q*a, by(t us)
gen id = 0 if us == 0 & t == 0 //SH control
replace id = 1 if us == 0 & t == 1 //SH treat
replace id = 2 if us == 1 & t == 0 //US control
replace id = 3 if us == 1 & t == 1 //US treat
rename q*a q*
drop q
reshape long q, i(id) j(question)
twoway connected q question if id == 0, lpattern(dash) color(maroon) msize(small) || connected q question if id == 2, color(navy) lpattern(dash) msize(small) || connected q question if id == 1, color(maroon) msize(small) || connected q question if id == 3, color(navy) msize(small) ///
		, legend(row(2) order(1 "Shanghai Control" 2 "U.S. Control" 3 "Shanghai Treatment" 4 "U.S. Treatment")) ytitle("Proportion Answered") xtitle("Question Number") ///
		scheme(s1color) yticks(0(0.1)1) ylabel( 0 "0" 0.1 ".1" 0.2 ".2" 0.3 ".3" 0.4 ".4" 0.5 ".5" 0.6 ".6" 0.7 ".7" 0.8 ".8" 0.9 ".9" 1 "1") plotregion(style(none) m(zero))
